program insertion_sort_string;
uses
  CRT, FileUtil;
var
  str, str_lat, str_kyr: string;
  i: integer;
{Процедура сортировки методом вставок латиницы}
procedure insert(var str: string);
var
  i, j: integer;
  v: char;
begin
  for i:= 2 to Length(str) do
  begin
    v:= str[i]; j:= i - 1;
    {Условие выхода из цикла: найдено подходящее место
    для текущего элемента или достигнуто начало строки}
    while (str[j] > v) and (j > 0) do
    begin
      str[j+1]:= str[j];
      dec(j);
    end;
    str[j+1]:= v;
  end;
end;

{Процедура сортировки методом вставок кирилицы}
procedure insert_kyr(var str: string);
var
  i, j: integer;
  v, v1: string[2];
begin
  for i:= 3 to Length(str) do
  begin
    v:= Copy( str, i, 2);
    j:= i - 2;
    {Условие выхода из цикла: найдено подходящее место
    для текущего элемента или достигнуто начало строки}
    while (Copy(str, j, 2) > v) and (j > 0) do
    begin
      v1:= Copy(str, j, 2);
      str[j+2]:= v1[1];
      str[j+3]:= v1[2];
      dec(j, 2);
    end;
    str[j+2]:= v[1];
    str[j+3]:= v[2];
  end;
end;

begin
  str:= 'зжедгвбаhgfedcbaиклijk';
  i:= 1;
  str_lat:= '';
  str_kyr:= '';
  while i <= Length(str) do
  begin
    if ord(str[i]) < 128
    then
    begin
      str_lat:= str_lat + str[i];
      inc(i);
    end
    else
    begin
      str_kyr:= str_kyr + Copy(str, i, 2);
      inc(i, 2);
    end;
  end;
  writeln(UTF8ToConsole('Исходная строка: '),
          UTF8ToConsole(str));
  insert(str_lat); // сортировка латиницы
  insert_kyr(str_kyr); // сортировка кириллицы
  str:= Concat(str_lat, str_kyr);
  writeln(UTF8ToConsole('Отсортированная строка: '),
          UTF8ToConsole(str));
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.


